VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmSubjectsTaken_StudentView 
   Caption         =   "Subjects Taken - Student View"
   ClientHeight    =   6180
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6645
   HelpContextID   =   472
   Icon            =   "Academic Registry Courses Taken - Students.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MDIChild        =   -1  'True
   ScaleHeight     =   6180
   ScaleWidth      =   6645
   Begin VB.CommandButton cmdFind 
      Height          =   675
      Left            =   5760
      Picture         =   "Academic Registry Courses Taken - Students.frx":000C
      Style           =   1  'Graphical
      TabIndex        =   14
      Top             =   360
      Width           =   735
   End
   Begin VB.CommandButton cmdPrevious 
      Caption         =   "<< Previous"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   1065
      TabIndex        =   11
      Top             =   5520
      Width           =   1275
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   4305
      TabIndex        =   10
      Top             =   5520
      Width           =   1275
   End
   Begin VB.CommandButton cmdNext 
      Caption         =   "Next >>"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   2685
      TabIndex        =   9
      Top             =   5520
      Width           =   1275
   End
   Begin VB.Frame Frame1 
      Caption         =   "Subjects"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3555
      Left            =   180
      TabIndex        =   4
      Top             =   1620
      Width           =   6255
      Begin VB.CommandButton cmdReset 
         Caption         =   "R"
         BeginProperty Font 
            Name            =   "Engravers MT"
            Size            =   15.75
            Charset         =   0
            Weight          =   500
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   555
         Left            =   5580
         Picture         =   "Academic Registry Courses Taken - Students.frx":0316
         TabIndex        =   8
         Top             =   1680
         Width           =   555
      End
      Begin VB.CommandButton cmdRemoveSubject 
         Height          =   555
         Left            =   5580
         Picture         =   "Academic Registry Courses Taken - Students.frx":0620
         Style           =   1  'Graphical
         TabIndex        =   7
         Top             =   1020
         Width           =   555
      End
      Begin VB.CommandButton cmdAddSubject 
         Height          =   555
         Left            =   5580
         Picture         =   "Academic Registry Courses Taken - Students.frx":092A
         Style           =   1  'Graphical
         TabIndex        =   6
         Top             =   360
         Width           =   555
      End
      Begin MSComctlLib.ListView lvwSubjects 
         Height          =   3015
         Left            =   180
         TabIndex        =   5
         Top             =   360
         Width           =   5295
         _ExtentX        =   9340
         _ExtentY        =   5318
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         FullRowSelect   =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         NumItems        =   0
      End
   End
   Begin VB.Label lblClass 
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Height          =   315
      Left            =   1440
      TabIndex        =   13
      Top             =   1020
      Width           =   4215
   End
   Begin VB.Label lblName 
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Height          =   315
      Left            =   1440
      TabIndex        =   12
      Top             =   600
      Width           =   4215
   End
   Begin VB.Label Label1 
      Caption         =   "Student ID"
      Height          =   195
      Left            =   195
      TabIndex        =   3
      Top             =   240
      Width           =   1155
   End
   Begin VB.Label Label5 
      Caption         =   "Class"
      Height          =   195
      Left            =   195
      TabIndex        =   2
      Top             =   1080
      Width           =   1155
   End
   Begin VB.Label Label3 
      Caption         =   "Name"
      Height          =   195
      Left            =   195
      TabIndex        =   1
      Top             =   660
      Width           =   1155
   End
   Begin VB.Label lblStudentID 
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Height          =   315
      Left            =   1440
      TabIndex        =   0
      Top             =   180
      Width           =   4215
   End
End
Attribute VB_Name = "frmSubjectsTaken_StudentView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private blnLoading As Boolean
Private rstStudents As New ADODB.Recordset


Private Sub RefreshSubjectsList()
    On Local Error GoTo errorHandler
    
    Dim intResponse As Long
    Dim objListItem As ListItem
    Dim rstQuery As New ADODB.Recordset
    Dim strSQL As String
    
    strSQL = "select student_subjects.subject_code as subject_code, subjects_offered.title as title , subjects_offered.teacher as teacher  from student_subjects left join subjects_offered on student_subjects.subject_code = subjects_offered.subject_code where student_subjects.student_id =  '" & lblStudentID.Caption & "'"
    rstQuery.Open strSQL, conIQ, adOpenStatic, adLockReadOnly
    lvwSubjects.ListItems.Clear
    While Not rstQuery.EOF
        Set objListItem = lvwSubjects.ListItems.Add
        objListItem.Text = rstQuery("subject_code")
        objListItem.SubItems(1) = rstQuery("title")
        objListItem.SubItems(2) = rstQuery("teacher") & " - " & getMemberOfStaffName(rstQuery("teacher"))
        rstQuery.MoveNext
    Wend
    
Exit Sub
errorHandler:
    intResponse = MsgBox(Err.Description, vbRetryCancel + vbExclamation)
    If intResponse = vbRetry Then
        Resume
    End If

End Sub

Private Sub cmdAddSubject_Click()
    frmSubjectsTaken_AddSubjects.Show vbModal
    RefreshSubjectsList
End Sub

Private Sub cmdClose_Click()
    Unload Me
End Sub

Private Sub cmdFind_Click()
    Dim strResponse As String
    Dim strCurrentRecord As String
    
    If Trim(lblStudentID.Caption) <> "" Then
        strCurrentRecord = lblStudentID.Caption
        strResponse = InputBox("Enter the ID of the student you wish to locate:", "Find Record")
        If strResponse <> "" Then
            rstStudents.MoveFirst
            rstStudents.Find "student_id = '" & strResponse & "'"
            If rstStudents.BOF Or rstStudents.EOF Then
                MsgBox "Record not found", vbExclamation
                rstStudents.Requery
                rstStudents.Find "student_id = '" & strCurrentRecord & "'"
            End If
        End If
    End If
    DisplayData

End Sub

Private Sub cmdNext_Click()
    On Local Error GoTo errorHandler
    
    Dim intResponse As Long
    
    If Not (rstStudents.BOF And rstStudents.EOF) Then
        If rstStudents.BOF Then
            rstStudents.MoveFirst
        ElseIf rstStudents.EOF Then
            rstStudents.MoveLast
        Else
            rstStudents.MoveNext
        End If
    End If
    DisplayData
    
Exit Sub
errorHandler:
    intResponse = MsgBox(Err.Description, vbRetryCancel + vbExclamation)
    If intResponse = vbRetry Then
        Resume
    End If

End Sub

Private Sub cmdPrevious_Click()
    On Local Error GoTo errorHandler
    
    Dim intResponse As Long
    
    If Not (rstStudents.BOF And rstStudents.EOF) Then
        If rstStudents.BOF Then
            rstStudents.MoveFirst
        ElseIf rstStudents.EOF Then
            rstStudents.MoveLast
        Else
            rstStudents.MovePrevious
        End If
    End If
    DisplayData
    
Exit Sub
errorHandler:
    intResponse = MsgBox(Err.Description, vbRetryCancel + vbExclamation)
    If intResponse = vbRetry Then
        Resume
    End If

End Sub


Private Sub cmdRemoveSubject_Click()
    On Local Error GoTo errorHandler
    
    Dim intResponse As Long
    Dim cmdQuery As New ADODB.Command
    Dim strSQL As String
    
    If lvwSubjects.ListItems.Count = 0 Then
        MsgBox "There are no subjects to remove", vbExclamation
    ElseIf lvwSubjects.SelectedItem Is Nothing Then
        MsgBox "Please select a subject first.", vbExclamation
    Else
        intResponse = MsgBox("Are you sure you want to deregister " & lblName.Caption & " from " & lvwSubjects.SelectedItem.SubItems(1) & ".", vbQuestion + vbYesNo)
        If intResponse = vbYes Then
            strSQL = "Delete from student_subjects where subject_code = '" & lvwSubjects.SelectedItem.Text & "' and student_id = '" & lblStudentID.Caption & "'"
            cmdQuery.CommandText = strSQL
            cmdQuery.ActiveConnection = conIQ
            cmdQuery.Execute
            RefreshSubjectsList
        End If
    End If
    
Exit Sub
errorHandler:
    intResponse = MsgBox(Err.Description, vbRetryCancel + vbExclamation)
    If intResponse = vbRetry Then
        Resume
    End If

End Sub

Private Sub cmdReset_Click()
    On Local Error GoTo errorHandler
    
    Dim intResponse As Long
    Dim cmdQuery As New ADODB.Command
    Dim strSQL As String
    
    If lvwSubjects.ListItems.Count = 0 Then
        MsgBox "There are no subjects to remove.", vbExclamation
    Else
        intResponse = MsgBox("Are you sure you want to remove all of the subjects registered for this student.", vbQuestion + vbYesNo)
        If intResponse = vbYes Then
            strSQL = "Delete from student_subjects where student_id = '" & lblStudentID.Caption & "'"
            cmdQuery.CommandText = strSQL
            cmdQuery.ActiveConnection = conIQ
            cmdQuery.Execute
            RefreshSubjectsList
        End If
    End If
    
Exit Sub
errorHandler:
    intResponse = MsgBox(Err.Description, vbRetryCancel + vbExclamation)
    If intResponse = vbRetry Then
        Resume
    End If

End Sub

Private Sub Form_Activate()
    On Local Error GoTo errorHandler
    
    Dim intResponse As Long
    
    If blnLoading Then
        blnLoading = False
        rstStudents.Open "select student_id, class from enrolled_students", conIQ, adOpenDynamic, adLockOptimistic
        
        'format list
        lvwSubjects.View = lvwReport
        lvwSubjects.ColumnHeaders.Clear
        lvwSubjects.ColumnHeaders.Add , , "Subject Code", 1155
        lvwSubjects.ColumnHeaders.Add , , "Title", 2010
        lvwSubjects.ColumnHeaders.Add , , "Teacher", 1880
        
        Me.Width = 6765
        Me.Height = 6585
    Else
        rstStudents.Requery
        If lblStudentID.Caption <> "" Then
            rstStudents.Find "student_id = '" & lblStudentID.Caption & "'"
        End If
    End If
    
    DisplayData
    
Exit Sub
errorHandler:
    intResponse = MsgBox(Err.Description, vbRetryCancel + vbExclamation)
    If intResponse = vbRetry Then
        Resume
    End If

End Sub

Private Sub Form_Load()
    blnLoading = True
End Sub

Private Sub Form_Unload(Cancel As Integer)
    On Local Error Resume Next
    rstStudents.Close
End Sub

Private Sub DisplayData()
    On Local Error GoTo errorHandler
    
    Dim intResponse As Long
    
    If Not (rstStudents.BOF And rstStudents.EOF) Then
        If rstStudents.BOF Then rstStudents.MoveFirst
        If rstStudents.EOF Then rstStudents.MoveLast
        lblStudentID.Caption = rstStudents("student_id")
        lblName.Caption = getStudentName(rstStudents("student_id"))
        lblClass.Caption = getClassName(rstStudents("class"))
        RefreshSubjectsList
    Else
        ClearAllBorderedLabels Me
        RefreshSubjectsList
    End If
    
Exit Sub
errorHandler:
    intResponse = MsgBox(Err.Description, vbRetryCancel + vbExclamation)
    If intResponse = vbRetry Then
        Resume
    End If
    
End Sub
